/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.mutantmore.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.Util;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.gui.overlay.ForgeGui;

public class OverlayUtils {
    protected static int lastHealth;
    protected static int displayHealth;
    protected static long lastHealthTime;
    protected static long healthBlinkTime;

    public static void renderScreenOverlay(ResourceLocation p_168709_, float p_168710_, int screenWidth, int screenHeight) {
        RenderSystem.m_69465_();
        RenderSystem.m_69458_((boolean)false);
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)p_168710_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)p_168709_);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_5483_(0.0, (double)screenHeight, -90.0).m_7421_(0.0f, 1.0f).m_5752_();
        bufferbuilder.m_5483_((double)screenWidth, (double)screenHeight, -90.0).m_7421_(1.0f, 1.0f).m_5752_();
        bufferbuilder.m_5483_((double)screenWidth, 0.0, -90.0).m_7421_(1.0f, 0.0f).m_5752_();
        bufferbuilder.m_5483_(0.0, 0.0, -90.0).m_7421_(0.0f, 0.0f).m_5752_();
        tesselator.m_85914_();
        RenderSystem.m_69458_((boolean)true);
        RenderSystem.m_69482_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void renderCustomHearts(ForgeGui gui, RandomSource random, int width, int height, PoseStack pStack, ResourceLocation heartTexture) {
        boolean highlight;
        gui.getMinecraft().m_91307_().m_6180_("health");
        RenderSystem.m_69478_();
        Player player = (Player)gui.getMinecraft().m_91288_();
        int health = Mth.m_14167_((float)player.m_21223_());
        boolean bl = highlight = healthBlinkTime > (long)gui.m_93079_() && (healthBlinkTime - (long)gui.m_93079_()) / 3L % 2L == 1L;
        if (health < lastHealth && player.f_19802_ > 0) {
            lastHealthTime = Util.m_137550_();
            healthBlinkTime = gui.m_93079_() + 20;
        } else if (health > lastHealth && player.f_19802_ > 0) {
            lastHealthTime = Util.m_137550_();
            healthBlinkTime = gui.m_93079_() + 10;
        }
        if (Util.m_137550_() - lastHealthTime > 1000L) {
            lastHealth = health;
            displayHealth = health;
            lastHealthTime = Util.m_137550_();
        }
        lastHealth = health;
        int healthLast = displayHealth;
        AttributeInstance attrMaxHealth = player.m_21051_(Attributes.f_22276_);
        float healthMax = Math.max((float)attrMaxHealth.m_22135_(), (float)Math.max(healthLast, health));
        int absorb = Mth.m_14167_((float)player.m_6103_());
        int healthRows = Mth.m_14167_((float)((healthMax + (float)absorb) / 2.0f / 10.0f));
        int rowHeight = Math.max(10 - (healthRows - 2), 3);
        random.m_188584_((long)(gui.m_93079_() * 312871));
        int left = width / 2 - 91;
        int top = height - gui.leftHeight;
        int regen = -1;
        if (player.m_21023_(MobEffects.f_19605_)) {
            regen = gui.m_93079_() % Mth.m_14167_((float)(healthMax + 5.0f));
        }
        OverlayUtils.renderHearts(gui, random, pStack, player, left, top, rowHeight, regen, healthMax, health, healthLast, absorb, highlight, heartTexture);
        RenderSystem.m_69461_();
        gui.getMinecraft().m_91307_().m_7238_();
    }

    protected static void renderHearts(ForgeGui gui, RandomSource random, PoseStack pStack, Player player, int left, int top, int rowHeight, int regen, float healthMax, int health, int healthLast, int absorb, boolean highlight, ResourceLocation heartTexture) {
        int i = player.f_19853_.m_6106_().m_5466_() ? 9 : 0;
        int j = Mth.m_14165_((double)((double)healthMax / 2.0));
        for (int i1 = j - 1; i1 >= 0; --i1) {
            int j1 = i1 / 10;
            int k1 = i1 % 10;
            int l1 = left + k1 * 8;
            int i2 = top - j1 * rowHeight;
            if (health + absorb <= 4) {
                i2 += random.m_188503_(2);
            }
            if (i1 < j && i1 == regen) {
                i2 -= 2;
            }
            int j2 = i1 * 2;
            int healthRows = Mth.m_14167_((float)((healthMax + (float)absorb) / 2.0f / 10.0f));
            int heightCorrection = healthRows > 9 ? 37 + (healthRows - 10) * 3 : 11 + ((healthRows - 1) * 9 - (healthRows - 2) * (healthRows - 2));
            RenderSystem.m_157456_((int)0, (ResourceLocation)ForgeGui.f_93098_);
            OverlayUtils.renderContainerHeart(gui, pStack, l1, i2 + heightCorrection, false, highlight);
            RenderSystem.m_157456_((int)0, (ResourceLocation)heartTexture);
            if (highlight && j2 < healthLast) {
                boolean flag2 = j2 + 1 == healthLast;
                OverlayUtils.renderHeart(gui, pStack, l1, i2 + heightCorrection, i, true, flag2);
            }
            if (j2 >= health) continue;
            boolean flag3 = j2 + 1 == health;
            OverlayUtils.renderHeart(gui, pStack, l1, i2 + heightCorrection, i, false, flag3);
        }
    }

    public static int getHeartX(boolean blinking, boolean half) {
        int j = blinking ? 1 : 0;
        int k = half ? 2 : 0;
        int i = j + k;
        return i * 9;
    }

    private static void renderHeart(ForgeGui gui, PoseStack pStack, int screenX, int screenY, int textureY, boolean half, boolean blinking) {
        ForgeGui.m_93133_((PoseStack)pStack, (int)screenX, (int)screenY, (float)OverlayUtils.getHeartX(blinking, half), (float)textureY, (int)9, (int)9, (int)36, (int)18);
    }

    private static void renderContainerHeart(ForgeGui gui, PoseStack pStack, int screenX, int screenY, boolean half, boolean blinking) {
        ForgeGui.m_93133_((PoseStack)pStack, (int)screenX, (int)screenY, (float)(52 + OverlayUtils.getHeartX(blinking, half)), (float)9.0f, (int)9, (int)9, (int)256, (int)256);
    }
}

